package ar.edu.unju.fi.junit.manager;

import ar.edu.unju.fi.junit.exceptions.ModelException;
import ar.edu.unju.fi.junit.modelo.Alumno;

import java.util.ArrayList;
import java.util.List;

public class AlumnoManager {
	private List<Alumno> listaAlumnos;
	
	public AlumnoManager(){
		listaAlumnos = new ArrayList<Alumno>();
	}

	public void agregarAlumno(Alumno alumno) {
		if (!validar(alumno)) {
			throw new IllegalArgumentException("Alumno no valido. El nombre es nulo o vacío.");
		}
		if (listaAlumnos.size() == 2) {
			throw new ModelException("Se alcanzó el tope máximo de 2...");
		}
		listaAlumnos.add(alumno);
	}

	/**
	 * Realiza todas las validaciones del Crear Alumno
	 * @param alumno
	 * @return
	 */
	public boolean validar(Alumno alumno) {
		return alumno != null && alumno.getNombre() != null && !alumno.getNombre().isEmpty();
	}

	public void eliminarAlumno(Alumno alumno){
		listaAlumnos.remove(alumno);
	}
	
	/**
	 * Busqueda de alumnos por nombre
	 * @param nombre
	 * @return
	 */
	public Alumno buscar(String nombre) {
		for(Alumno alumno: listaAlumnos) {
			if(alumno.getNombre().equalsIgnoreCase(nombre))
				return alumno;
		}
		return null;
	}
	
	public List<Alumno> listarActivos() {
		List<Alumno> resultado = new ArrayList<Alumno>();
		
		for(Alumno alumno: listaAlumnos) {
			if(alumno.getEstado())
				resultado.add(alumno);
		}
		return resultado;
	}
	
}
