package ar.edu.unju.fi.jpaoverview.repository;

import ar.edu.unju.fi.jpaoverview.domain.Usuario;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;
import java.util.Optional;

/**
 * @author José Zapana
 */
public interface UsuarioRepository extends JpaRepository<Usuario, Long> {
    Optional<Usuario> findByEmail(String email);
    Optional<Usuario> findByUsername(String username);
    List<Usuario> findByNombreContainingIgnoreCase(String nombre);
}
