package ar.edu.unju.fi.jpaoverview.dto;

import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * DTO para exponer/recibir datos de Usuario sin exponer la entidad JPA directamente.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UsuarioDTO {
    private Long id;

    @Email @NotBlank
    private String email;

    @NotBlank
    private String nombre;

    @NotBlank
    private String username;

    // En creación/entrada permitimos contraseña, pero no se devuelve en listados
    @Size(min = 8, message = "La contraseña debe tener al menos 8 caracteres")
    private String password;

    @PastOrPresent
    private LocalDateTime fechaAlta;

    private String dni;

    // Simplificamos el Rol a su descripción para el DTO
    @NotBlank
    private String rol;
}
