package ar.edu.unju.fi.jpaoverview.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/test")
public class TestController {

    @Operation(
            summary = "Ping de prueba",
            description = "Devuelve pong para verificar que la API está activa",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Respuesta exitosa")
            }
    )
    @GetMapping
    public String ping() {
        return "pong";
    }
}
