package ar.edu.unju.fi.jpaoverview;

import ar.edu.unju.fi.jpaoverview.domain.Rol;
import ar.edu.unju.fi.jpaoverview.domain.Usuario;
import ar.edu.unju.fi.jpaoverview.service.UsuarioService;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class JpaoverviewApplication {

	public static void main(String[] args) {
		SpringApplication.run(JpaoverviewApplication.class, args);
	}


    /**
     * Un CommandLineRunner es una interfaz de Spring Boot que permite ejecutar
     * código automáticamente una vez que la aplicación ha iniciado.
     *
     * Se utiliza generalmente para inicializar datos, ejecutar tareas de configuración
     * o pruebas rápidas al inicio.
     *
     * En este caso, el CommandLineRunner carga datos de ejemplo en la base de datos
     * (roles, usuarios, etc.) apenas se levanta la aplicación.
     *
     * @author José Zapana
     * @param usuarios
     * @return
     */
	@Bean
	@org.springframework.boot.autoconfigure.condition.ConditionalOnProperty(
			name = "app.demo", havingValue = "true", matchIfMissing = false
	)
	CommandLineRunner demo(UsuarioService usuarios) {
		return args -> {
			System.out.println("=== DEMO JPA SIN REST ===");

			// 1) crear rol y usuario
			var rolAdmin = Rol.builder().descripcion("ADMIN").build();
			var u = Usuario.builder()
					.email("leo@ejemplo.com")
					.nombre("Leo Messi")
					.username("leo")
					.password("secreto123") // sin hash por ahora
					.rol(rolAdmin)
					.build();

			var guardado = usuarios.crear(u);
			System.out.println("Usuario creado: id=" + guardado.getId() + ", username=" + guardado.getUsername());

			// 2) listar
			System.out.println("Usuarios en BD:");
			usuarios.listar().forEach(usr ->
					System.out.println(" - " + usr.getId() + " | " + usr.getUsername() + " | " + usr.getEmail())
			);

			// 3) buscar por username
			var encontrado = usuarios.buscarPorUsername("leo");
			System.out.println("Encontrado -> " + encontrado.getNombre() + " (" + encontrado.getEmail() + ")");
		};
	}
}
