package ar.edu.unju.fi.jpaoverview;

import ar.edu.unju.fi.jpaoverview.domain.Rol;
import ar.edu.unju.fi.jpaoverview.domain.Usuario;
import ar.edu.unju.fi.jpaoverview.repository.RolRepository;
import ar.edu.unju.fi.jpaoverview.repository.UsuarioRepository;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;

import java.util.List;

import static org.assertj.core.api.Assertions.assertThat;

@DataJpaTest
@AutoConfigureTestDatabase(replace = AutoConfigureTestDatabase.Replace.ANY)
class UsuarioRepositoryTest {

    @Autowired
    UsuarioRepository usuarios;

    @Autowired
    RolRepository roles;

    @Test
    void insertar_listar_buscarUsuario() {
        // insertar rol
        Rol rol = roles.save(Rol.builder().descripcion("USER").build());

        // insertar usuario
        Usuario u = Usuario.builder()
                .email("test@ejemplo.com")
                .nombre("Test User")
                .username("testuser")
                .password("password123")
                .rol(rol)
                .build();

        Usuario guardado = usuarios.save(u);
        assertThat(guardado.getId()).isNotNull();

        // listar
        List<Usuario> todos = usuarios.findAll();
        assertThat(todos).isNotEmpty();

        // buscar por username
        var encontrado = usuarios.findByUsername("testuser");
        assertThat(encontrado).isPresent();
        assertThat(encontrado.get().getEmail()).isEqualTo("test@ejemplo.com");
    }
}
