package ar.edu.unju.fi.junit;
import ar.edu.unju.fi.junit.exceptions.ModelException;
import ar.edu.unju.fi.junit.manager.AlumnoManager;
import ar.edu.unju.fi.junit.modelo.Alumno;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

import java.util.List;

@ExtendWith(MockitoExtension.class)
class AlumnoServiceTest {

    @Mock
    private List<Alumno> listaAlumnos;

    @InjectMocks
    private AlumnoManager alumnoService;

    private Alumno alumnoValido;
    private Alumno alumnoInvalido;

    @BeforeEach
    void setUp() {
        alumnoValido = new Alumno(1234, "Juan");
        alumnoInvalido = new Alumno(8765, null); // Alumno sin nombre
    }

    @Test
    void agregarAlumno_deberiaAgregarSiEsValidoYHayEspacio() {
        when(listaAlumnos.size()).thenReturn(1);

        alumnoService.agregarAlumno(alumnoValido);

        verify(listaAlumnos, times(1)).add(alumnoValido);
    }

    @Test
    void agregarAlumno_deberiaLanzarExcepcionSiEsInvalido() {
        // Aserta: Lanza una IllegalArgumentException
        assertThrows(IllegalArgumentException.class, () -> alumnoService.agregarAlumno(alumnoInvalido),
                "Se esperaba una IllegalArgumentException para un alumno inválido");

        // Aserta: Verifica que el método 'add' nunca se llamó
        verify(listaAlumnos, never()).add(any(Alumno.class));
    }

    @Test
    void agregarAlumno_deberiaLanzarExcepcionCuandoListaEstaLlena() {
        when(listaAlumnos.size()).thenReturn(2);

        assertThrows(ModelException.class, () -> alumnoService.agregarAlumno(alumnoValido),
                "Se esperaba que se lanzara una ModelException");

        verify(listaAlumnos, never()).add(any(Alumno.class));
    }
}