package ar.edu.unju.fi.poo.modelo;

public class CuentaBancaria {
    private Integer id;
    private String nombre;
    private Double saldo;

    private static Integer nextId = 0;

    /**
     * Constructor con id y nombre
     * Se ejecuta solamente cuando se crea un objeto (operador new)
     * @param id
     * @param nombre
     */
    public CuentaBancaria(Integer id, String nombre) {
        this.id = id;
        this.nombre = nombre;
        this.saldo = 0.0;
    }

    public CuentaBancaria(String nombre) {
        this.nombre = nombre;
        this.saldo = 0.0;
        nextId++;
        this.id = nextId;

    }

    @Override
    public String toString() {
        return "CuentaBancaria{" +
                "id=" + id +
                ", nombre='" + nombre + '\'' +
                ", saldo=" + saldo +
                '}';
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public Double getSaldo() {
        return saldo;
    }

    public void setSaldo(Double saldo) {
        this.saldo = saldo;
    }
}
