package com.reservahotel.reservations.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.reservahotel.reservations.config.ReservationServiceConfiguration;
import com.reservahotel.reservations.model.PropertiesReservation;
import com.reservahotel.reservations.model.Reservation;
import com.reservahotel.reservations.services.IReservationService;

@RestController
public class ReservationController {
	
	@Autowired
	private IReservationService service;
	
	@Autowired
	private ReservationServiceConfiguration configReservation;		

	@GetMapping("reservations")
	public List<Reservation> search(){
		return (List<Reservation>) this.service.search();	
	}
	
	/**
	 * EndPoint de prueba para leer las properties del microservicio
	 * configserver-ms
	 * 
	 * @return
	 * @throws JsonProcessingException
	 */
	@GetMapping("/reservation/read/properties")
	public String getPropertiesHotels()throws JsonProcessingException{
		ObjectWriter owj = new ObjectMapper().writer().withDefaultPrettyPrinter();
		PropertiesReservation propReservations = new PropertiesReservation(configReservation.getMsg(), configReservation.getBuildVersion(),configReservation.getMailDetails());
		System.out.println("propReservation: " + propReservations.getMsg()+ " - " + configReservation.getBuildVersion() +  " - "+ configReservation.getMailDetails());
		String jsonString = owj.writeValueAsString(propReservations);
		return jsonString;
	}	

}
