package com.reservahotel.hotels.controller;

import java.util.List;

import com.reservahotel.hotels.model.HotelRooms;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.reservahotel.hotels.config.HotelsServiceConfiguration;
import com.reservahotel.hotels.model.Hotel;
import com.reservahotel.hotels.model.PropertiesHotels;
import com.reservahotel.hotels.services.IHotelService;


@RestController
public class HotelController {
	
	@Autowired
	private IHotelService service;
	
	@Autowired
	private HotelsServiceConfiguration configHotels;	
	
	@GetMapping("hotels")
	public List<Hotel> search(){
		return (List<Hotel>) this.service.search();	
	}

	/**
	 * Consumiendo las habitaciones de un hotel determinado extraído del
	 * microservicio de rooms
	 * @param id
	 * @return
	 */
	@GetMapping("hotels/{id}")
	public HotelRooms searchHotelById(@PathVariable long id){
		return this.service.searchHotelById(id);
	}
	
	/**
	 * EndPoint de prueba para leer las properties del microservicio
	 * configserver-ms
	 * 
	 * @return
	 * @throws JsonProcessingException
	 */
	@GetMapping("/hotels/read/properties")
	public String getPropertiesHotels()throws JsonProcessingException{
		ObjectWriter owj = new ObjectMapper().writer().withDefaultPrettyPrinter();
		PropertiesHotels propHotels = new PropertiesHotels(configHotels.getMsg(), configHotels.getBuildVersion(),configHotels.getMailDetails());
		
		String jsonString = owj.writeValueAsString(propHotels);
		return jsonString;
	}
}
