package com.reservahotel.rooms.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.reservahotel.rooms.config.RoomServiceConfiguration;
import com.reservahotel.rooms.model.PropertiesRooms;
import com.reservahotel.rooms.model.Room;
import com.reservahotel.rooms.services.IRoomService;


@RestController
public class RoomController {

	@Autowired
	private IRoomService service;
	
	@Autowired
	private RoomServiceConfiguration configRooms;	
	
	@GetMapping("rooms")
	public List<Room> search(){
		return (List<Room>) this.service.search();	
	}

	/**
	 * Devuelve las habitaciones de un hotel determinado
	 * @param id
	 * @return
	 */
	@GetMapping("rooms/{id}")
	public List<Room> searchByHotelId(@PathVariable long id){

		return (List<Room>) this.service.searchRoomByHotelId(id);
	}
	/**
	 * EndPoint de prueba para leer las properties del microservicio
	 * configserver-ms
	 * 
	 * @return
	 * @throws JsonProcessingException
	 */
	@GetMapping("/rooms/read/properties")
	public String getPropertiesHotels()throws JsonProcessingException{
		ObjectWriter owj = new ObjectMapper().writer().withDefaultPrettyPrinter();
		PropertiesRooms propHotels = new PropertiesRooms(configRooms.getMsg(), configRooms.getBuildVersion(),configRooms.getMailDetails());
		System.out.println("propHotels: " + propHotels.getMsg()+ " - " + configRooms.getBuildVersion() +  " - "+ configRooms.getMailDetails());
		String jsonString = owj.writeValueAsString(propHotels);
		return jsonString;
	}


}
