package com.reservahotel.hotels.services.client;

import com.reservahotel.hotels.model.Room;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * Configuración para indicar que se va a consumir el servicio
 * utilizando Feign.
 * Se indica con que nombre se registra el
 * microservicio de rooms en Eureka "rooms"
 * @author jzapana
 */
@FeignClient("rooms")
public interface RoomsFeignClient {

    @RequestMapping(method = RequestMethod.GET, value="rooms/{id}", consumes ="application/json")
    public List<Room> searchHotelById(@PathVariable long id);
}
