package com.reservahotel.hotels.services;

import java.util.*;

import com.reservahotel.hotels.model.HotelRooms;
import com.reservahotel.hotels.model.Room;
import com.reservahotel.hotels.services.client.RoomsFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.reservahotel.hotels.dao.IHotelDao;
import com.reservahotel.hotels.model.Hotel;
import org.springframework.web.client.RestTemplate;

@Service
public class HotelServiceImpl implements IHotelService {
	
	@Autowired
	private IHotelDao hotelDao;

	@Autowired
	private RestTemplate clientRest;

	@Autowired
	RoomsFeignClient roomsFeignClient;

	@Override
	public HotelRooms searchHotelById(long hotelId) {
		HotelRooms response = new HotelRooms();
		Optional<Hotel> hotel = hotelDao.findById(hotelId);

		//RestTemplate
		//Map<String, Long> pathVariable = new HashMap<String, Long>();
		//pathVariable.put("id", hotelId);
		//List<Room> rooms = Arrays.asList(clientRest.getForObject("http://localhost:8081/rooms/{id}", Room[].class, pathVariable));

		List<Room> rooms = roomsFeignClient.searchHotelById(hotelId);

		response.setHotelId(hotel.get().getHotelId());
		response.setHotelName(hotel.get().getHotelName());
		response.setHotelAddress(hotel.get().getHotelAddress());
		response.setRooms(rooms);
		return response;
	}


	@Override
	public List<Hotel> search() {
		return (List<Hotel>) hotelDao.findAll();
	}


}
