package com.reservahotel.hotels;

import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
/**
 * Ejemplo básico de RestTemplate
 * @author jose_
 *
 */
public class RestTemplateExample {

    public static void main(String[] args) {
        // Crear una instancia de RestTemplate
        RestTemplate restTemplate = new RestTemplate();

        // URL del servicio web externo
        String apiUrl = "https://jsonplaceholder.typicode.com/posts/1";

        // Realizar una solicitud HTTP GET
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(apiUrl, String.class);

        // Obtener el cuerpo de la respuesta
        String responseBody = responseEntity.getBody();

        // Mostrar la respuesta en la consola
        System.out.println("Respuesta del servicio web:");
        System.out.println(responseBody);
    }
}
