# jpaoverview

📘 *Caso de estudio de un backend básico con JPA*

Este proyecto es una exploración práctica de Java Persistence API (JPA) en el contexto de un backend sencillo. A través de ejemplos progresivos, se busca comprender el funcionamiento de JPA, la gestión de entidades, y la integración con distintas tecnologías de persistencia.

El proyecto comienza con una base de datos en memoria (H2) y evoluciona hacia MySQL, incorporando herramientas complementarias como Redis y Liquibase para enriquecer el ecosistema backend.

---

## 🚀 Tecnologías utilizadas

- **Java 21**
- **Maven**
- **JPA / Hibernate**
- **H2 Database**
- **MySQL**
- **Redis** (pruebas futuras)
- **Liquibase** (pruebas futuras)

---

## 🎯 Objetivos del proyecto

- Implementar un backend básico con JPA y H2.
- Migrar la persistencia hacia MySQL.
- Realizar pruebas con Redis como almacenamiento complementario.
- Integrar Liquibase para el versionado de esquemas.
- Documentar cada paso como parte de un caso de estudio educativo.
- Explorar buenas prácticas en diseño de backend y persistencia.

---


---

## 🧪 Cómo ejecutar

Este proyecto usa Maven. Para compilar y ejecutar:

```bash
mvn clean install
mvn spring-boot:run

📚 Estado actual
✅ Backend básico con JPA + H2
🔜 Migración a MySQL
🔜 Pruebas con Redis
🔜 Integración de Liquibase
🔜 Documentación del caso de estudio