package ar.edu.unju.fi.junit;

import ar.edu.unju.fi.junit.manager.AlumnoManager;
import ar.edu.unju.fi.junit.modelo.Alumno;
import org.junit.jupiter.api.*;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;


@DisplayName("no-funcional...")
class AlumnoManagerTestCase {
	static AlumnoManager target;
	static Alumno alumno;
	static Alumno alumno2;
	static Alumno alumno3;

	/**
	 * Este método ocurre antes de TODOS los test case
	 * @throws Exception
	 */
	@BeforeAll
	static void setUpBeforeClass() throws Exception {
		System.out.println("Iniciando Test...");
	}

	/**
	 * Se ejecuta al final de TODOS los test case
	 * @throws Exception
	 */
	@AfterAll
	static void tearDownAfterClass() throws Exception {
		System.out.println("finalizando...");
	}

	/**
	 * Se ejecuta antes de CADA UNO de los escenario o Test
	 * @throws Exception
	 */
	@BeforeEach
	void setUp() throws Exception {
		System.out.println("Configurando en SetUp...");
		target = new AlumnoManager();
		alumno = new Alumno(1,"AAAA");
		alumno2 = new Alumno(2,"BBBB");
		alumno3 = new Alumno(3,"CCCC");				
	}

	/**
	 * Se ejecuta al final de CADA UNO de los TestCase
	 * @throws Exception
	 */
	@AfterEach
	void tearDown() throws Exception {
		System.out.println("Limpiando variables...");
		target = null;
		alumno = null;
		alumno2 = null;
		alumno3 = null;				
	}

	@Test
	@DisplayName("Agregar Alumno")
	void agregarAlumnoTest() {
		System.out.println("Iniciando prueba de AgregarAlumno...");		
		target.agregarAlumno(alumno);
		Alumno alumnoBuscado = target.buscar("AAAA");
		assertNotNull(alumnoBuscado);
		target.eliminarAlumno(alumnoBuscado);
		Alumno alumnoBuscadoII = target.buscar("AAAA");
		assertNull(alumnoBuscadoII);
	}
	
	@Test
	@DisplayName("Eliminar Alumno")
	@Disabled
	void agregaAlumnoTest() {
		System.out.println("Iniciando prueba de Eliminar...");		
		target.agregarAlumno(alumno);
		Alumno alumnoBuscado = target.buscar("AAAA");
		assertNotNull(alumnoBuscado);
		target.eliminarAlumno(alumnoBuscado);
		Alumno alumnoBuscadoII = target.buscar("AAAA");
		assertNull(alumnoBuscadoII);
	}
	
	@Test
	@DisplayName("Listar Activos")
	void listaActivosTest() {
		System.out.println("Iniciando prueba de Listar Activos...");		
		target.agregarAlumno(alumno);
		target.agregarAlumno(alumno2);
		target.agregarAlumno(alumno3);
		List<Alumno> lista = target.listarActivos();
		assertEquals(lista.size(), 3);
		alumno2.setEstado(Boolean.FALSE);
		lista = target.listarActivos();
		assertEquals(lista.size(), 2);
		
	}

}
