package ar.edu.unju.fi.junit.manager;

import ar.edu.unju.fi.junit.modelo.Alumno;

import java.util.ArrayList;
import java.util.List;

public class AlumnoManager {
	private List<Alumno> listaAlumnos;
	
	public AlumnoManager(){
		listaAlumnos = new ArrayList<Alumno>();
	}
	
	public void agregarAlumno(Alumno alumno){
		if(!validar(alumno))
			System.out.println("Alumno no valido");
		listaAlumnos.add(alumno);
	}

	/**
	 * Realiza todas las validaciones del Crear Alumno
	 * @param alumno
	 * @return
	 */
	private boolean validar(Alumno alumno) {
		return Boolean.TRUE;
	}

	public void eliminarAlumno(Alumno alumno){
		listaAlumnos.remove(alumno);
	}
	
	/**
	 * Busqueda de alumnos por nombre
	 * @param nombre
	 * @return
	 */
	public Alumno buscar(String nombre) {
		for(Alumno alumno: listaAlumnos) {
			if(alumno.getNombre().equalsIgnoreCase(nombre))
				return alumno;
		}
		return null;
	}
	
	public List<Alumno> listarActivos() {
		List<Alumno> resultado = new ArrayList<Alumno>();
		
		for(Alumno alumno: listaAlumnos) {
			if(alumno.getEstado())
				resultado.add(alumno);
		}
		return resultado;
	}
	
}
